/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: dyndefs.h
 * -----------------------------------------------------------------*/

#ifndef XDYNDEFS_H_INCLUDED
#define XDYNDEFS_H_INCLUDED

/* ---------------------------------------------------------------
 * Type Definitions for paramter types and paraminfotypes
 * This is used for the dynamic capabilities lists. The lists and
 * functions return data structures of the following types.
 * License Information is also kept  here. Depending on the license
 * the user has different parameters can get chosen or not. This is
 * encoded in the paramter information.
 * --------------------------------------------------------------- */


typedef enum { /* used to distinguish what kind of parameter/signal is stored*/
  BX_PARAM_CUSTOM = 0,          /* has to be zero!!, CZ */

  BX_PARAM_EXERCISER_GEN,       /* has generic and param info */
  BX_PARAM_ANALYZER_GEN,        /* has generic and param info */
  BX_PARAM_RI_GEN,              /* has generic and param info */
  BX_PARAM_CT_GEN,              /* has generic and param info */
  BX_PARAM_CI_GEN,              /* has generic and param info */
  BX_PARAM_RT_GEN,              /* has generic and param info */

  BX_PARAM_RI_BLOCK,            /* has generic and param info */

  BX_PARAM_CT_BEH,              /* has generic and param info */
  BX_PARAM_CT_SPLITCOND,        /* has generic and param info */
  BX_PARAM_RI_BEH,              /* has generic and param info */
  BX_PARAM_CI_BEH,              /* has generic and param info */
  BX_PARAM_RT_BEH,              /* has generic and param info */

  BX_PARAM_DECODER_GEN,         /* generic info about all decoders */
  BX_PARAM_DECODER_STD,         /* has generic, param standard decoder */
  BX_PARAM_DECODER_EXP,         /* has generic, param expansion rom dec*/
  BX_PARAM_DECODER_CFG,         /* has generic, param config decoder */
  BX_PARAM_DECODER_REQ,         /* has generic, param RT decoder */

  BX_PARAM_DATA_MEM,            /* has generic info only */
  BX_PARAM_TRACE_GEN,           /* generic trace props, generic, param */
  BX_PARAM_TRACE_MEM,           /* has generic and param info */
  BX_PARAM_PATTERN,             /* has generic and param info */
  BX_PARAM_TRIGSEQ_GEN,         /* generic and param */
  BX_PARAM_TRIGSEQ_TRAN,        /* generic and param */
  BX_PARAM_TRIGSEQ_COND,        /* generic and param */
  BX_PARAM_PERFSEQ_GEN,         /* generic and param */
  BX_PARAM_PERFSEQ_TRAN,        /* generic and param */
  BX_PARAM_PERFSEQ_COND,        /* generic and param */
  BX_PARAM_OBSRULES,            /* generic and param, only strings  */
  BX_PARAM_STATUS,              /* holds the card's status properties */
  BX_PARAM_BOARD,               /* board properties */
  BX_PARAM_CPCI_PIN,            /* pin info for Compact PCI */
  BX_PARAM_CPCI_STATUS,         /* status info for Compact PCI */

  BX_PARAM_LAST                 /* for range checking only */
} bx_paramtype;

/* the following enum is especially interesting for the ct decode window,
   but other applications may also be possible:
   the ct decoder properties are categorized into four groups:
    - view props: View-Only, may be shown but never changed
    - hard props: May be changed, but only as power-up defaults
    - soft props: May be changed even in a running system
    - other     : Not shown, (e.g. properties that are ignored anyway for
                              normal behavior)
*/
typedef enum {
  BX_DEC_PROP_VIEW,
  BX_DEC_PROP_HARD,
  BX_DEC_PROP_SOFT,
  BX_DEC_PROP_OTHER
} bx_deccategorytype;

#ifndef BEST_FIRMWARE

#include <xbddefs.h>
#include <xladefs.h>
#include <xlatrdef.h>
#include <xridefs.h>
#include <xexerdef.h>
#include <xanadef.h>
#include <xobsdefs.h>
#include <xperfdef.h>
#include <xpropdef.h>
#include <xctdefs.h>
#include <xrtdefs.h>
#include <xtdecdef.h>
#include <xtrcdefs.h>
#include <xtriodef.h>
#include <xcidefs.h>

/********************************************************************
  Mapping to Hardware ***********************************************
 *******************************************************************/

/* This struct contains info about the size and position of the 
   properties in hardware */
typedef struct
{
  bx_int32 PropId;         /* Property id (e.g. BX_RIBLK_BYTEN)            */
  bx_charptrtype PropName; /* Property name (e.g. "BX_RIBLK_BYTEN")        */
  bx_int32 PropLen;        /* length of (maybe partial) property in bit  */
  bx_int32 PropBitPos;     /* bit-offset in property in range [0,..,31]  */
  bx_int32 MemBitPos;      /* corresponding memory offset 
                              in range [0,..,BX_<>_WIDTH*16-1] */
} bx_memmaptype;

/* this is always the last entry */
#define MEMMAP_LASTENTRY ((bx_int32) 0xFFFFFFFFUL)

/*****************************************************************************
 * parameter rules
 *****************************************************************************/
/* some of the parameters must follow special rules (must be dividable by
 * four (dword boundary) or dividable by 128 ... whatever)
 * these defines remember these special cases */

#define BX_PARAMRULE_NORULE         0x0000 /* no rule for this parameter */
#define BX_PARAMRULE_DWORDBOUND     0x0001 /* must be dword aligned */
#define BX_PARAMRULE_128BOUND       0x0002 /* must be 128-aligned */
#define BX_PARAMRULE_EVEN           0x0004 /* must be even */
#define BX_PARAMRULE_MINMAXONLY     0x0008 /* only min and max vals allowed */

/* numbers 0x10 to 0x40 are used by pattern term definitions */

#define BX_PARAMRULE_ZEROALLOWED    0x0080 /* this one allows a range between x
                                              and y as well as a value of 0 for
                                              range checking */
#define BX_PARAMRULE_MAXLONGALLOWED 0x0100 /* values between min, max and -1 */
#define BX_PARAMRULE_ZERO2WIDTH     0x0200 /* For timing checker signals:
                                              Minimum value for mask is zero
                                              and maximum is (2^width)-1
                                              Remark: signal width is stored in
                                              max_val (see
                                              e2926a_tc_signal_table[]) */

#define BX_PARAMRULE_BITSET         0x0400 /* Allows set of values (range
                                              [minval+0,..,minval+31] with
                                              holes) Each set Bit represents an
                                              allowed value */

#define BX_PARAMRULE_PPRVAR         0x0800 /* parameter is allowed for PPR
                                              variation */

#define BX_PARAMRULE_DEC_BIOS     0x1000 /* parameter is a bios-respected */
        /* property */

typedef union {
  bx_paramtype       param;           /* param for more  dyncap info */
  bx_riblktype       riblkprop;       /* RI block properties     */
  bx_ribehtype       ribehprop;       /* RI behavior properties */
  bx_ctbehtype       ctbehprop;       /* CT behavior properties */
  bx_ctsplittype     splitcondprop;   /* CT split conditions */
  bx_cibehtype       cibehprop;       /* CI behavior properties */
  bx_rtbehtype       rtbehprop;       /* RT behavior properties */
  bx_dectype         decoder;         /* decoder                     */
  bx_decproptype     decprop;         /* decoder properties          */
  bx_deccategorytype deccategory;     /* decoder prop categories     */
  bx_rigentype       rigenprop;       /* RI generic properties   */
  bx_egentype        egenprop;        /* exerciser generic properties*/
  bx_agentype        agenprop;        /* analyzer generic properties*/
  bx_ctgentype       ctgenprop;       /* CT generic properties   */
  bx_cigentype       cigenprop;       /* CI generic properties   */
  bx_rtgentype       rtgenprop;       /* RT generic properties */
  bx_tracetype       traceprop;       /* generic trace properties    */
  bx_signaltype      signalprop;      /* signals                     */
  bx_triggentype     trigseqgenprop;  /* TriggerSequencer generic P. */
  bx_trigtrantype    trigseqtranprop; /* TriggerSeq. transition Prop */
  bx_trigcondtype    trigseqcondprop; /* TriggerSeq. condition Props */
  bx_perfgentype     perfseqgenprop;  /* Perf. Seq. generic Props    */
  bx_perftrantype    perfseqtranprop; /* Perf. Seq. transition Props */
  bx_perfcondtype    perfseqcondprop; /* Perf. Seq. condition Props  */
  bx_obsruletype     obsrule;         /* the Observer Rule           */
  bx_statustype      status;          /* the card's   Status type    */
  bx_boardtype       boardprop;       /* generic board properties    */
  bx_int32           value;           /* needed for the cast         */
} bx_paramproptype;

typedef struct {
  bx_charptrtype  param_name;        /* namestring of standard form        */
  bx_charptrtype  param_short;       /* namestring of the short form       */
  bx_ccharptrtype param_propname;    /* name in BX_ format (for CAPI)      */
  bx_int32        min_val;           /* minimum value also bitstart(signal)*/
  bx_int32        max_val;           /* maximum value also width (signal)  */
  bx_int32        defaultval;        /* default value of this parameter    */
  bx_charptrtype  defaultstr;        /* some params require strings (equat)*/
  bx_int32        paramrule;         /* param might have a special rule    */
  bx_paramproptype  proptyp;         /* property for the C-API call (union)*/
  const bx_param_stringlisttype * stringlist; /* array of possible stringlists */
  bx_int32   group;                  /* group info */
  const bx_memmaptype * memmap;      /* memory map (for block/behaviors) */
} bx_param_infotype;


typedef struct {
  bx_charptrtype  group_name;       /* the name of the group (error need) */
  bx_int32        depth;            /* depth of block/attr/memory/ etc    */
  bx_int32        num_elem;         /* number of decoder/signals etc      */
  bx_int32        num_pages;        /* number of pages (needed sometimes) */
  bx_int32        num_blocks;       /* blocks_per_page*num_pages */
  bx_int32        int_mem_offset;   /* where to start in internal memory  */
  bx_int32        fixeddelay;       /* delay between blocks in usec       */
} bx_generic_infotype;

typedef struct _bx_infotype {
  bx_generic_infotype * geninfo;      /* the generic info */
  bx_param_infotype   * paraminfo;    /* the parameter info (array) */
} bx_infotype;

struct  bx_dynamic_capability_type {

  /* license information */
  bx_int32* capa_code;

  bx_infotype * info;        /* array, will be newed in CapaInit */
};

#endif /* if not BEST_FIRMWARE */

#endif
